#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// City-lightsMod01.fsh    by   Izixs  
//https://www.shadertoy.com/view/MfcyDj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Reinder Nijhoff 2014
// Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
// @reindernijhoff
//
// https://www.shadertoy.com/view/Xtf3zn
//
// Tokyo by night in the rain. The car model is made by Eiffie
// (Shiny Toy': https://www.shadertoy.com/view/ldsGWB). 
// I have never been in Tokyo btw.


#define BUMPMAP
#define MARCHSTEPS 100
#define MARCHSTEPSREFLECTION 48
#define LIGHTINTENSITY 10.
#define FOG_DENSITY 0.02
#define FOG_HEIGHT_FALLOFF 0.15


//----------------------------------------------------------------------

const vec3 backgroundColor = vec3(0.2,0.4,0.9) * 0.09;
#define time (iTime + 90.)

//----------------------------------------------------------------------
// noises



float hash( float n ) {
    return fract(sin(n)*687.3123);
}

float noise( in vec2 x ) {
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f*f*(3.0-2.0*f);
    float n = p.x + p.y*157.0;
    return mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
               mix( hash(n+157.0), hash(n+158.0),f.x),f.y);
}

const mat2 m2 = mat2( 0.80, -0.60, 0.60, 0.80 );

float fbm( vec2 p ) {
    float f = 0.0;
    f += 0.5000*noise( p ); p = m2*p*2.02;
    f += 0.2500*noise( p ); p = m2*p*2.03;
    f += 0.1250*noise( p ); p = m2*p*2.01;
//    f += 0.0625*noise( p );
    
    return f/0.9375;
}

//----------------------------------------------------------------------
// distance primitives

float udRoundBox( vec3 p, vec3 b, float r ) {
  return length(max(abs(p)-b,0.0))-r;
}





float sdBox( in vec3 p, in vec3 b ) {
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdSphere( in vec3 p, in float s ) {
    return length(p)-s;
}

float sdCylinder( in vec3 p, in vec2 h ) {
    vec2 d = abs(vec2(length(p.xz),p.y)) - h;
    return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

//----------------------------------------------------------------------
// distance operators

float opU( float d2, float d1 ) { return min( d1,d2); }
float opS( float d2, float d1 ) { return max(-d1,d2); }
float smin( float a, float b, float k ) { return -log(exp(-k*a)+exp(-k*b))/k; } //from iq

//----------------------------------------------------------------------
// Map functions

// car model is made by Eiffie
// shader 'Shiny Toy': https://www.shadertoy.com/view/ldsGWB

float mapCar(in vec3 p0){ 
	vec3 p=p0+vec3(0.0,1.24,0.0);
	float r=length(p.yz);
	float d= length(max(vec3(abs(p.x)-0.35,r-1.92,-p.y+1.4),0.0))-0.05;
	d=max(d,p.z-1.0);
	p=p0+vec3(0.0,-0.22,0.39);
	p.xz=abs(p.xz)-vec2(0.5300,0.9600);p.x=abs(p.x);
	r=length(p.yz);
	d=smin(d,length(max(vec3(p.x-0.08,r-0.25,-p.y-0.08),0.0))-0.04,8.0);
	d=max(d,-max(p.x-0.165,r-0.24));
	float d2=length(vec2(max(p.x-0.13,0.0),r-0.2))-0.02;
	d=min(d,d2);

	return d;
}

float dL; // minimal distance to light

float map( const in vec3 p ) {
	vec3 pd = p;
    float d;
    
    pd.x = abs( pd.x );
    pd.z *= -sign( p.x );
    //Purpose: Controls the spawning of cars along the road
    float ch = hash( floor( (pd.z+18.* time)/40. ) );
    
    //Purpose: Creates variation in building lights and structures
    float lh = hash( floor( pd.z/13. ) );
    
    
    vec3 pdm = vec3( pd.x, pd.y, mod( pd.z, 10.) - 5. );
    dL = sdSphere( vec3(pdm.x-8.1,pdm.y-4.5,pdm.z), 0.1 );
    
    //building lights 
    dL = opU( dL, sdBox( vec3(pdm.x-12., pdm.y-9.5-lh,  mod( pd.z, 91.) - 45.5 ), vec3(0.2,4.5, 0.2) ) );
    dL = opU( dL, sdBox( vec3(pdm.x-12., pdm.y-11.5+lh, mod( pd.z, 31.) - 15.5 ), vec3(0.22,5.5, 0.2) ) );
    dL = opU( dL, sdBox( vec3(pdm.x-12., pdm.y-8.5-lh,  mod( pd.z, 41.) - 20.5 ), vec3(0.24,3.5, 0.2) ) );
   
    if( lh > 0.5 ) {
    //Middle lights
	    dL = opU( dL, sdBox( vec3(pdm.x-12.5,pdm.y-2.75-lh,  mod( pd.z, 13.) - 6.5 ), vec3(0.1,0.25, 3.2) ) );
    }
    
    vec3 pm = vec3( mod( pd.x + floor( pd.z * 4. )*0.25, 0.5 ) - 0.25, pd.y, mod( pd.z, 0.25 ) - 0.125 );
	//Creates the roundbox?
    d = udRoundBox( pm, vec3( 0.245,0.1, 0.12 ), 0.005 ); 
      
      //Road
    d = opS( d, -(p.x+8.) );
    d = opU( d, pd.y );
    
    
    //Movement for the cars
    vec3 pdc = vec3( pd.x, pd.y, mod( pd.z+18.*time, 40.) - 20. );
    
    // car
    if( ch > 0.75 ) {
        pdc.x += (ch-0.75)*4.;
	    dL = opU( dL, sdSphere( vec3( abs(pdc.x-5.)-1.05, pdc.y-0.55, pdc.z ),    0.025 ) );
	    dL = opU( dL, sdSphere( vec3( abs(pdc.x-5.)-1.2,  pdc.y-0.65,  pdc.z+6.05 ), 0.025 ) );

        d = opU( d,  mapCar( (pdc-vec3(5.,-0.025,-2.3))*0.45 ) );
 	}
    //Background buildings
    d = opU( d, 13.-pd.x );
        //LightPost
    d = opU( d, sdCylinder( vec3(pdm.x-8.5, pdm.y, pdm.z), vec2(0.075,4.5)) );
    d = opU( d, dL );
    
	return d;
}

//----------------------------------------------------------------------

// Calculate surface normal without bump mapping
vec3 calcNormalSimple(in vec3 pos) {   
    // Small offset for numerical derivatives
    const vec2 e = vec2(1.0,-1.0)*0.005;  // Creates tiny offsets for sampling

    // Calculate normal by sampling 4 nearby points and getting their distance field values
    // This creates a gradient that points perpendicular to the surface
    vec3 n = normalize(
        e.xyy*map(pos + e.xyy) +  // Sample +x direction
        e.yyx*map(pos + e.yyx) +  // Sample +z direction
        e.yxy*map(pos + e.yxy) +  // Sample +y direction
        e.xxx*map(pos + e.xxx)    // Sample all positive directions
    );  
    return n;
}

// Calculate surface normal with optional bump mapping
vec3 calcNormal(in vec3 pos) {
    // Get base normal first
    vec3 n = calcNormalSimple(pos);
    
    // For higher surfaces (above road level), return simple normal
    if(pos.y > 0.12) return n;

#ifdef BUMPMAP
    // Calculate texture coordinates for bump mapping
    // Creates a grid pattern for surface detail
    vec2 oc = floor(vec2(pos.x+floor(pos.z * 4.)*0.25, pos.z) * vec2(2., 4.));

    // Special case for road surface (when x is within ±8 units)
    if(abs(pos.x)<8.) {
        oc = pos.xz;  // Use direct position for road texture
    }
    
    // Scale position for noise sampling
    vec3 p = pos * 250.;
    // Create bump normal offset using noise
    // First layer of detail
    vec3 xn = 0.05*vec3(noise(p.xz)-0.5, 0., noise(p.zx)-0.5);
    // Add second layer of detail using FBM for more complexity
    xn += 0.1*vec3(fbm(oc.xy)-0.5, 0., fbm(oc.yx)-0.5);
    
    // Combine base normal with bump normal
    n = normalize(xn + n);
#endif
    
    return n;
}

// Global variables for storing intersection and lighting information
vec3 int1, int2, nor1;    // int1/2: intersection points, nor1: surface normal
vec4 lint1, lint2;        // Light intersection info (position + distance)

// Main ray marching function that finds intersections with the scene
float intersect(in vec3 ro, in vec3 rd) {
    const float precis = 0.001;      // Precision/threshold for surface detection
    float h = precis*2.0;            // Initial step size
    float t = 0.;                    // Distance traveled along ray
    int1 = int2 = vec3(-500.);      // Initialize intersection points
    lint1 = lint2 = vec4(-500.);    // Initialize light intersection data
    float mld = 100.;                // Minimum light distance
    
    // First pass: find primary intersection
    for(int i=0; i < MARCHSTEPS; i++) {
        h = map(ro+rd*t);            // Get distance to nearest surface
        // Track closest approach to lights
        if(dL < mld){
            mld = dL;
            lint1.xyz = ro+rd*t;      // Store position
            lint1.w = abs(dL);        // Store distance to light
        }
        // If we hit a surface, store intersection point and break
        if(h < precis) {
            int1.xyz = ro+rd*t;
            break;
        } 
        t += max(h, precis*2.);      // Step along ray (at least precis*2 units)
    }
    
    // Handle case where we didn't hit anything or went too far
    if(int1.z < -400. || t > 300.) {
        // Try to intersect with ground plane at y = -0.1
        float d = -(ro.y + 0.1)/rd.y;
        if(d > 0.) {
            int1.xyz = ro+rd*d;
        } else {
            return -1.;              // No intersection found
        }
    }
    
    // Set up for reflection pass
    ro = ro + rd*t;                  // Move to intersection point
    nor1 = calcNormal(ro);           // Calculate surface normal
    ro += 0.01*nor1;                 // Slight offset to prevent self-intersection
    rd = reflect(rd, nor1);          // Calculate reflection direction
    t = 0.0;                         // Reset distance
    h = precis*2.0;                  // Reset step size
    mld = 100.;                      // Reset minimum light distance
    
    // Second pass: find reflection intersection
    for(int i=0; i < MARCHSTEPSREFLECTION; i++) {
        h = map(ro+rd*t);            // Get distance to nearest surface
        // Track closest approach to lights
        if(dL < mld){
            mld = dL;            
            lint2.xyz = ro+rd*t;      // Store position
            lint2.w = abs(dL);        // Store distance to light
        }
        // If we hit a surface, store intersection and return
        if(h < precis) {
            int2.xyz = ro+rd*t;
            return 1.;                // Reflection hit found
        }   
        t += max(h, precis*2.);      // Step along ray
    }
    return 0.;                       // No reflection hit found
}
//----------------------------------------------------------------------
// shade

vec3 shade( in vec3 ro, in vec3 pos, in vec3 nor ) {
   //Pavement color
   //Light color
   vec3  col = vec3(.183,.177,.163);
    //Define a dark boundary between 15 and 8
    if( abs(pos.x) > 15. || abs(pos.x) < 8. ) col = vec3( 0.02 );
    //Whiite lines for the street
    if( pos.y < 0.01 ) {
        if( abs( int1.x ) < 0.1 ) col = vec3( 0.9 );
        if( abs( abs( int1.x )-7.4 ) < 0.1 ) col = vec3( 0.9 );
    }    
    
 // Adjusted sky light direction and intensity for blue-ish atmosphere
    float sh = clamp(dot(nor, normalize(vec3(-0.2, 0.6, -0.3))), 0.,2.);
    // Mix with blue sky color
    col *= (sh * mix(backgroundColor, vec3(0.1, 0.6, 1.0), 0.5));
    if( abs( pos.x ) > 12.9 && pos.y > 9.) { // windows
        float ha = hash(133.1234*floor(pos.y / 3.) + floor((pos.z) / 3.));
        if( ha > 0.95) {
            col = ((ha-0.95)*10.) * vec3(2.7, 2.8, 0.25); // Cooler window lights
        }
    }
    
    //atmospheric distance fog/haze effect, making distant objects blend with the background color
	col = mix(  backgroundColor, col, exp( min(max(0.1*pos.y,0.25)-0.065*distance(pos, ro),0.) ) );
  
    return col;
}

vec3 getLightColor(in vec3 pos) {
    // Initialize with warm white/orange base light color
    vec3 lcol = vec3(1., .7, .5);  // Red=100%, Green=70%, Blue=50%
    
    // Create a copy of position for manipulation
    vec3 pd = pos;
    pd.x = abs(pd.x);           // Mirror the scene across x=0 for symmetry
    pd.z *= -sign(pos.x);       // Flip z direction based on which side of x=0 we're on
    
    // Generate random value for car placement (changes with time)
    // pd.z+18.*time makes cars move forward, /40. controls spacing between potential car positions
    float ch = hash(floor((pd.z+18.*time)/40.));

    // Calculate position for moving cars
    // mod(..., 40.) - 20. keeps cars within a repeating 40 unit section, centered around 0
    vec3 pdc = vec3(pd.x, pd.y, mod(pd.z+18.*time, 40.) - 20.);

    if(ch > 0.75) { // Only spawn cars when random value > 0.75 (25% of the time)
        pdc.x += (ch-0.75)*4.;  // Vary car's position across road width
        
        // Check if current point is within car taillight area
        // Complex position calculation to place lights relative to car
        if(sdSphere(vec3(abs(pdc.x-5.)-1.05, pdc.y-0.55, pdc.z), 0.25) < 2.) {
            lcol = vec3(1., 0.05, 0.01);  // Bright red color for taillights
        }
    }

    // Handle lower building lights (between 2 and 5 units high, and more than 10 units from center)
    if(pd.y > 2. && abs(pd.x) > 10. && pd.y < 5.) {
        float fl = floor(pd.z/13.);  // Create sections every 13 units along z
        // Mix original color (40%) with randomized yellow-tinted color (50%)
        lcol = 0.4*lcol +                         // Keep 40% of original color
               0.5*vec3(hash(.1562+fl),           // Random red component
                       hash(.423134+fl),          // Random green component
                       0.);                       // No blue (creates yellow tint)
    }

    // Handle upper building lights (above 5 units high and more than 10 units from center)
    if(abs(pd.x) > 10. && pd.y > 5.) {
        float fl = floor(pd.z/2.);  // Create sections every 2 units along z
        // Mix original color (50%) with fully random RGB color (50%)
        lcol = 0.5*lcol +                         // Keep 50% of original color
               0.5*vec3(hash(.1562+fl),           // Random red component
                       hash(.923134+fl),          // Random green component
                       hash(.423134+fl));         // Random blue component
    }
   
    return lcol;  // Return the final light color
}
float randomStart(vec2 co){return 0.8+0.2*hash(dot(co,vec2(123.42,117.853))*412.453);}

//----------------------------------------------------------------------
// main

// Main rendering function
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   
   // Convert pixel coordinates to normalized screen coordinates [0,1]
   vec2 q = fragCoord.xy / iResolution.xy;
   // Convert to [-1,1] range for ray direction calculation
   vec2 p = -1.0 + 2.0*q;
   // Correct for aspect ratio
   p.x *= iResolution.x / iResolution.y;
       
   // Create black bars at top and bottom of screen (letterbox effect)
   if (q.y < .12 || q.y >= .88) {
       fragColor = vec4(0.,0.,0.,1.);
       return fragColor;
   } else {
       // Camera setup
       float z = time;                                    // Camera moves forward with time
       float x = -10.9+1.*sin(time*0.2);                 // Camera sways side to side
       // Camera position with subtle vertical movement
       vec3 ro = vec3(x, 1.3+.3*cos(time*0.26), z-1.);
       // Look-at point, also moves to create dynamic camera
       vec3 ta = vec3(-8.,1.3+.4*cos(time*0.26), z+4.+cos(time*0.04));

       // Calculate camera basis vectors for view matrix
       vec3 ww = normalize(ta - ro);                      // Forward vector
       vec3 uu = normalize(cross(ww,vec3(0.0,1.0,0.0))); // Right vector
       vec3 vv = normalize(cross(uu,ww));                 // Up vector

       // Calculate ray direction for this pixel
       vec3 rd = normalize(-p.x*uu + p.y*vv + 2.2*ww);
       
       // Start with background color
       vec3 col = backgroundColor;

       // Perform ray marching
       float ints = intersect(ro+randomStart(p)*rd, rd);
       
       // If we hit something
       if(ints > -0.5) {
           // Calculate surface reflectance
           float r = 0.09;     	        
           // Different reflection values for different heights
           if(int1.y > 0.129) 
               r = 0.025 * hash(133.1234*floor(int1.y / 3.) + floor(int1.z / 3.));
           
           // Special handling for road area
           if(abs(int1.x) < 8.) {
               if(int1.y < 0.01) { // road surface
                   r = 0.007*fbm(int1.xz);  // Use FBM for road texture
               } else { // car surface
                   r = 0.02;
               }
           }
           
           // Increase reflectance for road markings
           if(abs(int1.x) < 0.1) r *= 4.;              // Center line
           if(abs(abs(int1.x)-7.4) < 0.1) r *= 4.;    // Edge lines
           r *= 2.;                                    // Global reflection boost

           // Calculate primary surface color
           col = shade(ro, int1.xyz, nor1);

           // Add reflection color if we hit something in reflection ray
           if(ints > 0.5) {
               col += r * shade(int1.xyz, int2.xyz, calcNormalSimple(int2.xyz));
           }  
           
           // Add light contribution from reflection pass
           if(lint2.w > 0.) {            
               col += (r*LIGHTINTENSITY*exp(-lint2.w*7.0)) * getLightColor(lint2.xyz);
           } 
       } 

       // Rain effect calculation
       vec2 st = 256. * (p*vec2(.5, .01)+vec2(time*.13-q.y*.6, time*.13));
       float f = noise(st) * noise(st*0.773) * 1.55;
       f = 0.25 + clamp(pow(abs(f), 13.0) * 13.0, 0.0, q.y*.14);

       // Add light contribution from primary ray
       if(lint1.w > 0.) {
           col += (f*LIGHTINTENSITY*exp(-lint1.w*7.0)) * getLightColor(lint1.xyz);
       }  

       // Post processing steps
       // Gamma correction and color adjustment
       col = pow(clamp(col, 0.0, 1.0), vec3(0.545));
       col *= vec3(1.5, 1.0, 1.05);                   // Add slight red tint
       col = clamp(1.06*col-0.03, 0., 1.);           // Contrast adjustment
       
       // Calculate vignette effect
       q.y = (q.y-.12)*(1./0.76);                    // Adjust y coordinate for letterbox
       // Apply vignette (darker corners)
       col *= 0.5 + 0.5*pow(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y), 0.1);

       // Output final color
       fragColor = vec4(col, 1.0);
   }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

